#include "serialread.h"

serialread::serialread(QObject *parent)
    : QObject{parent}
{
    serialThread = new QThread;
    this->moveToThread(serialThread);
    serialThread->start();
}

serialread::~serialread() {
    if(serial->isOpen()){
        serial->close();
    }
    delete(serial);
    myTimer->stop();
    delete(myTimer);
}
void serialread::slotRequestSerialData() {
    if (serial->isOpen() == false){
        return;
    }

    serial->write("RAWDATA;",8);
    serial->waitForBytesWritten(10);
    serial->waitForReadyRead(40);

    while (serial->bytesAvailable() > 0){
        serialData.append(serial->readAll());
        serial->waitForReadyRead(5);
    }
    //split Qstring and change to int
    QString radar = QString::fromStdString(serialData.toStdString());
    QStringList buffer_split;

    buffer_split = radar.split(' ');
    if (buffer_split.count() == 257){
        emit signalSendDataToPlot(buffer_split);
    }

    serialData.clear();
}

void serialread::slotCreateSerialPort(QString ComPortName){
    serial = new QSerialPort(this);

    serial->setPortName(ComPortName);
    serial->setBaudRate(250000);
    serial->setDataBits(QSerialPort::Data8);
    serial->setParity(QSerialPort::NoParity);
    serial->setStopBits(QSerialPort::OneStop);
    serial->setFlowControl(QSerialPort::NoFlowControl);
    serial->open(QSerialPort::ReadWrite);
}

void serialread::slotDisconnect(){
    slotSetTimer(false);

    if(serial->isOpen() == true){
        serial->close();
    }
    else{
        return;
    }
}

void serialread::slotSetTimer(bool enable){
    if (myTimer == NULL){
        myTimer = new QTimer(this);
        myTimer->setInterval(10);
        connect(myTimer,SIGNAL(timeout()),this,SLOT(slotRequestSerialData()));
    }

    if (myTimer == NULL){
        return;
    }

    if(enable == true){
        myTimer->start();
    }
    else{
        disconnect(myTimer,SIGNAL(timeout()),this,SLOT(slotRequestSerialData()));
        myTimer->stop();
        delete(myTimer);
        myTimer = NULL;
    }
}
